#include "maindefs.h"
#include "imu.h"
#include "i2c.h"

void imu_init() {
    imu_gyro_init();
    imu_acc_init();
}

void imu_acc_init() {
    unsigned char toSend[2];
    toSend[0] = LSM303_CTRL_REG1_A;
    toSend[1] = 0x27;
    i2c_master_send(ACC_ADDRESS >> 1, 2, toSend);
    while(i2c_master_busy());
}

void imu_gyro_init() {
    unsigned char toSend[2];
    toSend[0] = L3G4200D_CTRL_REG1;
    toSend[1] = 0x0F;
    i2c_master_send(GYR_ADDRESS >> 1, 2, toSend);
    while(i2c_master_busy());
}

void imu_read_acc() {
    unsigned char toSend[1];
    toSend[0] = LSM303_OUT_X_L_A | 0x80;
    i2c_master_send(ACC_ADDRESS >> 1, 1, toSend);
    while(i2c_master_busy());
    i2c_master_recv(ACC_ADDRESS >> 1, 6);
    while(i2c_master_busy());
}

void imu_read_gyro() {
    unsigned char toSend[1];
    toSend[0] = L3G4200D_OUT_X_L | 0x80;
    i2c_master_send(GYR_ADDRESS >> 1, 1, toSend);
    while(i2c_master_busy());
    i2c_master_recv(GYR_ADDRESS >> 1, 6);
    while(i2c_master_busy());
}
